| Assembly Source File
| Created 24/09/2004; 23:18:41

main:

.global __L_plane
.global __D_plane
.global __switch_cnt

.global _ti92plus

.global _nostub

preshifted_16x16_sprite_size = 32*16*16/8

busybee1_offset = 0
vball1_offset = busybee1_offset + preshifted_16x16_sprite_size
vball2_offset = vball1_offset + preshifted_16x16_sprite_size 

# a5 pointe sur la table des syscalls
	move.l (0xC8),%a5

# alloue RAM
	move.l #preshifted_16x16_sprite_size*3,-(%sp)
	move.l 4*0x90(%a5),%a0
	jbsr (%a0)
	lea 4(%a7),%a7
	
	move.w %d0,handle

# dereference le handle
	move.w handle,-(%a7)
	move.l 4*0x96(%a5),%a0
	jbsr (%a0)
	addq.w #2,%a7
	move.l %a0,block

# Active niveaux de gris	
	jbsr GrayOn

	jbsr clear_screens

#
# inits
#

	lea busybee1,%a0
	move.l block,%a1
	lea +busybee1_offset(%a1),%a1
	jbsr PreCalc_16x16_preshifts
	
|	lea vball1,%a0
|	move.l block,%a1
|	lea +vball1_offset(%a1),%a1
|	jbsr PreCalc_16x16_preshifts

|	lea vball2,%a0
|	move.l block,%a1
|	lea +vball2_offset(%a1),%a1
|	jbsr PreCalc_16x16_preshifts

	jbsr init_3Drot	
	
#
# sequences

	jbsr clear_screens
		
	lea str_mjj,%a0
	move.w	#30,%d0
	move.w	#30,%d1
	jbsr prints
	
	lea str_present,%a0
	move.w	#70,%d0
	move.w	#90,%d1
	jbsr prints
	
	move.w	#200,%d0	
.l1:	jbsr vsync
	dbra	%d0,.l1

	jbsr clear_screens
	
	lea str_titre,%a0
	move.w	#50,%d0
	move.w	#50,%d1
	jbsr prints		


	move.w	#200,%d0	
.l2:	jbsr vsync
	dbra	%d0,.l2	
	
	jbsr FX_ImageComingFromRight
	jbsr FX_Lissajou
	jbsr FX_ImageGoingToRight
	jbsr clear_screens	
	
.rept   150	
	jbsr FX_3DDots
.endr	

	jbsr FX_ImageComingFromRight
	move.w	#50,%d0	
.l3:	jbsr vsync
	dbra	%d0,.l3
	
	jbsr FX_ImageGoingToRight
	jbsr clear_screens

	jbsr FX_3DDots
	jbsr clear_screens
		
.rept   150	
	jbsr FX_3DWireframe	
.endr	

	jbsr FX_ImageComingFromRight
	
	move.w	#50,%d0	
.l4:	jbsr vsync
	dbra	%d0,.l4
	
	jbsr FX_ImageGoingToRight
	jbsr clear_screens
	
	lea str_credit1,%a0
	move.w	#10,%d0
	move.w	#20,%d1
	jbsr prints
	
	lea str_credit2,%a0
	move.w	#40,%d0
	move.w	#20,%d1
	jbsr prints
	
	lea str_credit4,%a0
	move.w	#70,%d0
	move.w	#20,%d1
	jbsr prints
	
	lea str_credit3,%a0
	move.w	#90,%d0
	move.w	#20,%d1
	jbsr prints	


	jbsr GrayOff

	jbsr wait_key

	
# ------------------------------------
# On se casse
# ------------------------------------	
	

|libere RAM
	move.w handle,-(%a7)
	move.l 4*0x97(%a5),%a0
	jbsr (%a0)
	addq.w #2,%a7

	rts
| end !!!!


# -----------------------------------------
# sub routines

# ------------------------------------
# ...
# ------------------------------------
FX_ImageComingFromRight:
	moveq.l	#0,%d6			| clean registers
	moveq.l	#0,%d4
	moveq.l	#0,%d5
	
	move.w  #240/16-1,%d6		| counter = 14	

FX_ICFR_horiz_loop:
	move.l #alchimie_light,%d0	| saves picL pointer
	move.l #alchimie_dark,%d1	| saves picD pointer
	
	move.l __L_plane,%a4		| saves framebufferL pointer
	move.l __D_plane,%a5		| saves framebufferD pointer
	
	move.w	#128-1,%d7		| counter = 127
	
FX_ICFR_verti_loop:
	move.l %d0,%a0			| points to current picL line
	move.l %d1,%a1			| points to current picD line
	
	move.l %a4,%a2			| points to current framebufferL line 
	move.l %a5,%a3			| points to current framebufferD line 

	moveq.l	#240/16-1,%d5		| copy counter
	sub.l	%d6,%d5			| reverse counter = 15-d6
	
	move.l 	%d6,%d4
	add.l	%d4,%d4			| offset = 240-(nb blocks*16)
	adda.l	%d4,%a2			| points to framebufferL offset
	adda.l	%d4,%a3			| points to framebufferD offset
	
FX_ICFR_block16_loop:	
	move.w	(%a0)+,(%a2)+		| blit 16 pixels block
	move.w	(%a1)+,(%a3)+		| blit 16 pixels block

	dbra    %d5,FX_ICFR_block16_loop| loop until d5 16_blocks blitted [0-15]

	add.l	#2*240/16,%d0		| points to next picL line
	add.l	#2*240/16,%d1		| points to next picD line
	add.l	#2*240/16,%a4		| points to next framebufferL line
	add.l	#2*240/16,%a5		| points to next framebufferD line
	
	dbra	%d7,FX_ICFR_verti_loop	| loop until all lines blitted
	
	jbsr vsync
		
	dbra	%d6,FX_ICFR_horiz_loop	| loop until full line blitted
	rts

# ------------------------------------
# ...
# ------------------------------------
FX_ImageGoingToRight:
	moveq.l	#0,%d6			| clean registers
	moveq.l	#0,%d4
	moveq.l	#0,%d5
	
	move.w  #240/16-1,%d6		| counter = 14	

FX_IGTR_horiz_loop:
	move.l #alchimie_light,%d0	| saves picL pointer
	move.l #alchimie_dark,%d1	| saves picD pointer
	
	move.l __L_plane,%a4		| saves framebufferL pointer
	move.l __D_plane,%a5		| saves framebufferD pointer
	
	move.w	#128-1,%d7		| counter = 127
	
FX_IGTR_verti_loop:
	move.l %d0,%a0			| points to current picL line
	move.l %d1,%a1			| points to current picD line
	
	move.l %a4,%a2			| points to current framebufferL line 
	move.l %a5,%a3			| points to current framebufferD line 

	moveq.l	#240/16-1,%d5
	sub.l %d6,%d5
	move.l %d5,%d4
	add.l	%d4,%d4			| offset = 240-(nb blocks*16)
	adda.l	%d4,%a2			| points to framebufferL offset
	adda.l	%d4,%a3			| points to framebufferD offset
	
	move.l %d6,%d5
FX_IGTR_block16_loop:	
	move.w	(%a0)+,(%a2)+		| blit 16 pixels block
	move.w	(%a1)+,(%a3)+		| blit 16 pixels block

	dbra    %d5,FX_IGTR_block16_loop| loop until d5 16_blocks blitted [0-15]

	add.l	#2*240/16,%d0		| points to next picL line
	add.l	#2*240/16,%d1		| points to next picD line
	add.l	#2*240/16,%a4		| points to next framebufferL line
	add.l	#2*240/16,%a5		| points to next framebufferD line
	
	dbra	%d7,FX_IGTR_verti_loop	| loop until all lines blitted

	jbsr vsync
		
	jbsr clear_4_colors_screen

	dbra	%d6,FX_IGTR_horiz_loop	| loop until full line blitted
	rts

# ------------------------------------
# Lissajou Bee !
# ------------------------------------

FX_Lissajou:

	lea sintbl,%a6
	move.w #90*5-1,%d6
lissajouloop:

	move.l block,%a0
|	lea +vball1_offset(%a0),%a0
	move.l block,%a1
|	lea +vball2_offset(%a1),%a1
	move.l __L_plane,%a2
	move.l __D_plane,%a3
|	lea 0x4c00,%a3

	move.w %d6,%d0
	move.w %d6,%d1
|2t
	add.w %d0,%d0
|3t+5
	add.w %d0,%d1
	add.w %d6,%d1
|modulo 256
	moveq #0,%d2
	st %d2
|pour cos...
	add.w #256/4,%d0
	and.w %d2,%d0
|pour sin...
	and.w %d2,%d1
|cos
	move.b (%a6,%d1.w),%d1
|sin
	move.b (%a6,%d0.w),%d0

	asr.w #1,%d0
	add.w #30,%d0
	asr.w #2,%d1
	add.w #30,%d1

	move.w %d0,X
	move.w %d1,Y
	jbsr XOR_4_colors_draw_monochrome_16x16_sprite


	jbsr vsync


	move.l block,%a0
|	lea +vball1_offset(%a0),%a0
	move.l block,%a1
|	lea +vball2_offset(%a1),%a1
	move.l __L_plane,%a2
	move.l __D_plane,%a3

	move.w X,%d0
	move.w Y,%d1
	jbsr XOR_4_colors_draw_monochrome_16x16_sprite


	dbf %d6,lissajouloop
	rts



# ------------------------------------
# Preshift 16x16
# ------------------------------------
PreCalc_16x16_preshifts:
	moveq #16-1,%d7

wordloop:
	move.w (%a0)+,%d0
	moveq #0,%d1
	move.l %a1,%a2
	moveq #16-1,%d6
preshift:
	move.w %d0,(%a2)+
	move.w %d1,(%a2)+
	lsr.w #1,%d0
	roxr.w #1,%d1
	add.l #32/8*16-32/8,%a2
	dbf %d6,preshift

	add.l #32/8,%a1
	dbf %d7,wordloop
	rts




XOR_4_colors_draw_monochrome_16x16_sprite:
	move.w %d0,%d4
	and.w #0b1111,%d0
	mulu #32/8*16,%d0
	add.l %d0,%a0
	add.l %d0,%a1
	asr.w #4,%d4
	add.w %d4,%d4
	adda.l %d4,%a2
	adda.l %d4,%a3
	mulu #240/8,%d1
	adda.l %d1,%a2
	adda.l %d1,%a3

	move.w #16-1,%d2
	move.l #(240-32)/8,%d3
XOR_4_colors_draw_monochrome_16x16_sprite_loop:
	move.l (%a0)+,%d0
	eor.l %d0,(%a2)+
	move.l (%a1)+,%d1
	eor.l %d1,(%a3)+
	add.l %d3,%a2
	add.l %d3,%a3
|	move.l (%a0)+,(%a3)+
|	add.l %d3,%a3
	dbf %d2,XOR_4_colors_draw_monochrome_16x16_sprite_loop
	rts

AND_4_colors_draw_monochrome_16x16_sprite:
	move.w 	%d0,%d4
	and.w 	#0b1111,%d0
	mulu 	#32/8*16,%d0
	add.l 	%d0,%a0
	add.l 	%d0,%a1
	asr.w 	#4,%d4
	add.w 	%d4,%d4
	adda.l 	%d4,%a2
	adda.l 	%d4,%a3
	mulu 	#240/8,%d1
	adda.l 	%d1,%a2
	adda.l 	%d1,%a3

	move.w #16-1,%d2
	move.l #(240-32)/8,%d3
	
AND_4_colors_draw_monochrome_16x16_sprite_loop:
	move.l (%a0)+,%d1
	or.l %d1,(%a2)+
	move.l (%a1)+,%d1
	or.l %d1,(%a3)+
	add.l %d3,%a2
	add.l %d3,%a3
|	move.l (%a0)+,(%a3)+
|	add.l %d3,%a3
	dbf %d2,AND_4_colors_draw_monochrome_16x16_sprite_loop
	rts


prints:
	move.w #4,-(%a7)
	pea (%a0)
	move.w %d0,-(%a7)
	move.w %d1,-(%a7)
	move.l 4*0x1a9(%a5),%a0
	jbsr (%a0)
	adda.w #2+2+4+2,%sp
	rts


vsync:
	move.l %d0,-(%sp)
	move.l __switch_cnt,%d0
	addq.l #1,%d0
vsync_loop:
	cmp.l __switch_cnt,%d0
	bhi.s vsync_loop
	move.l (%sp)+,%d0
	rts


clear_screens:
	jbsr clear_system_screen
	jbsr clear_4_colors_screen
	rts


clear_system_screen:
|efface RAM video
	lea 0x4c00,%a0
	moveq.l #0,%d0
	jbsr fill_screen
	rts


clear_4_colors_screen:
|efface RAM Light
	move.l __L_plane,%a0
	moveq.l #0,%d0
	jbsr fill_screen
|efface RAM Dark
	move.l __D_plane,%a0
	moveq.l #0,%d0
	jbsr fill_screen
	rts


fill_screen:
	movem.l %d1-%d7/%a1-%a7,registers

	move.l %d0,%d1
	move.l %d0,%d2
	move.l %d0,%d3
	move.l %d0,%d4
	move.l %d0,%d5
	move.l %d0,%d6
	move.l %d0,%d7
	move.l %d0,%a1
	move.l %d0,%a2
	move.l %d0,%a3
	move.l %d0,%a4
	move.l %d0,%a5
	move.l %d0,%a6
	move.l %d0,%a7

	lea 2*240*128/16(%a0),%a0
	move.w #(240*128/32)/(6+7)-1,%d7
fill_screen_loop1:
	movem.l %d1-%d6/%a1-%a7,-(%a0)
	dbf %d7,fill_screen_loop1

	move.w #(240*128/32)-(6+7)*((240*128/32)/(6+7))-1,%d7
	bmi.s fill_screen_loop2_done
fill_screen_loop2:
	move.l %d0,-(%a0)
	dbf %d7,fill_screen_loop2
fill_screen_loop2_done:

	movem.l registers(%pc),%d1-%d7/%a1-%a7
	rts

	
|slow_fill_screen:
|	move.l %d1,-(%sp)
|	move.w #240*128/32-1,%d1
|slow_fill_screen_loop:
|	move.l %d0,(%a0)+
|	dbf %d1,slow_fill_screen_loop
|	move.l (%sp)+,%d1
|	rts

	
wait_key:
	movem.l %d0-%d7/%a0-%a6,-(%sp)
	
	move.l 4*0x51(%a5),%a0
	jbsr (%a0)
	
	movem.l (%sp)+,%d0-%d7/%a0-%a6	
	rts


put_image:
	move.w #240*128/4-1,%d0
	move.l __L_plane,%a2
	move.l __D_plane,%a3
put_image_loop:
	move.l (%a0)+,(%a2)+
	move.l (%a1)+,(%a3)+
	dbf %d0,put_image_loop
	rts

pixel_table_plotter:

	lea 0x4c00,%a2
	|move.l __L_plane,%a2
	|move.l __D_plane,%a3

	move.l #0x8000,%d6
	
	mulu	#30,%d2			| offset for y
	adda.l	%d2,%a2
	
		
	move.w	%d1,%d0
	lsr.w	#4,%d0			| which word
	and.w	#0xF,%d1
	
	add.w	%d0,%d0
	add.w	%d0,%a2
	
	lsr.w	%d1,%d6
	
	or.w	%d6,(%a2)	

	rts
	
pixel_table_eraser:
	
	lea 0x4c00,%a2
	|move.l __L_plane,%a2
	|move.l __D_plane,%a3

	move.l #0x8000,%d6
	
	mulu	#30,%d1			| offset for y
	adda.l	%d1,%a2
		
	move.w	%d0,%d2
	lsr.w	#4,%d2			| which word
	and.w	#0xF,%d0
	
	add.w	%d2,%d2
	add.w	%d2,%a2
	
	lsr.w	%d0,%d6
	
	not.w	%d6
	and.w	%d6,(%a2)	

	rts	

# ---------------------------
# includes



str_mjj:
.ascii "Shazz/MJJ Prod & Gwile"
.byte 0

.even

str_present:
.ascii "Present"
.byte 0

.even

str_titre:
.ascii "Ze Fujibee Demo"
.byte 0

.even

str_credit1:
.ascii "Code: Gwile & Shazz "
.byte 0

.even

str_credit2:
.ascii "Credits: Nounours & Billy"
.byte 0

.even

str_credit3:
.ascii "ATARI RULEZ"
.byte 0

.even

str_credit4:
.ascii "Greets to Alchimie People!"
.byte 0

.even

registers:
.long 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
.long 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15

handle:
.word 0

block:
.long 0

busybee1:
|       edcba9876543210
.word 0b000010000000000
.word 0b000010000011110
.word 0b000000000110001
.word 0b000001101100001
.word 0b110001101000010
.word 0b000110011000101
.word 0b000110110101010
.word 0b000001101110000
.word 0b000111010101100
.word 0b001100111111110
.word 0b011000010110000
.word 0b010000101101111
.word 0b010001001101100
.word 0b010010100101011
.word 0b001101000001010
.word 0b000000000000000

vball2:
.word	0x07E0,0x1FF8
.word	0x31FC,0x6CFE
.word	0x5E7E,0xDE7F
.word	0xCC7F,0xE0FF
.word	0xF1FF,0xFFFF
.word	0xFFFF,0x7FFE
.word	0x7FFE,0x3FFC
.word	0x1FF8,0x07E0
vball1:
.word	0x0000,0x0000
.word	0x0E00,0x1F00
.word	0x3F80,0x3F80
.word	0x3F80,0x1F00
.word	0x0E00,0x0000
.word	0x0000,0x0000
.word	0x0000,0x0000
.word	0x0000,0x0000

sintbl:
.byte 127,131,134,137,140,144,147,150,153,156
.byte 158,162,165,168,171,174,177,180,182,185
.byte 187,191,194,196,199,201,204,206,209,211
.byte 213,216,218,220,222,224,226,228,230,232
.byte 233,236,237,239,240,242,243,244,246,247
.byte 247,249,250,251,251,252,253,253,254,254
.byte 253,255,255,255,255,255,255,255,254,254
.byte 252,253,252,252,251,250,249,248,247,246
.byte 244,244,242,241,240,238,236,235,233,231
.byte 228,227,225,223,221,219,217,215,212,210
.byte 207,205,203,200,197,195,192,189,187,184
.byte 180,178,175,172,169,167,164,160,157,154
.byte 150,148,145,142,139,136,133,130,126,123
.byte 119,117,114,111,108,105,102,99,96,92
.byte 88,87,84,81,78,75,72,69,67,64
.byte 60,59,56,53,51,48,46,44,41,39
.byte 36,35,33,31,29,27,25,23,21,20
.byte 17,16,15,14,12,11,10,9,8,7
.byte 5,5,4,4,3,3,2,2,1,1
.byte 0,1,1,1,1,2,2,2,3,3
.byte 3,5,5,6,7,8,9,10,12,13
.byte 13,16,17,19,20,22,24,26,28,30
.byte 31,34,36,38,40,42,45,47,50,52
.byte 54,57,60,62,65,68,71,74,76,79
.byte 81,85,88,91,94,97,100,103,106,109
.byte 111,116,119,122,125,128

.even

alchimie_light:
.word 0x057F,0xFFFB,0x5FFF,0xDFDE,0xF5FF,0xFFFF,0xFFFF,0xFFFF,0xDBFF,0xFFFF,0xFFFE,0x8805,0x10FF,0xF8BF,0xFFFF,0x03FF,0xFFFE,0xFFEF,0xFEB7,0xFFBA,0xFFFF,0xFFDF,0xFFFF,0x7D7F,0xFFFF,0xFFFF,0xF680,0x0123,0x80FF,0xFFFF,0x2FFF,0xFFB5,0xFFBF,0xFBFE,0x9FFF,0xCBD7,0xB7FF,0xFFFF,0xF7FF,0xF7F7,0xFFFF,0xFDAA,0x8000,0x002B,0xFFFF,0x57FF,0xFFEF,0xFEFF,0x5FFB,0xFBED,0xFF7E,0xFFDF,0xFD5B,0xFDAF,0xFFDD,0x6FFF,0xFFFD,0x2804,0x0D17,0xFFFF,0xABFF,0xFFFF,0xEBFD,0xFFFF,0xBEBF,0xFBEF,0xDB7F,0xD6BF,0xFFFF,0xFF7F,0xFBFF,0xFFFF,0xFF02,0xA4F9,0xFFFF,0x7DFF,0xFFFF,0xBFFF,0xFFFF,0xFBDF,0x5FFF,0xFFFD,0xFB56,0xDBBE,0xFDFF,0xEEFF,0xFFFF,0xFFD0,0x8154,0x7FFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFD,0xFD7A,0xDB6F,0x55BF,0xFFFF,0xEFFF,0x7FBF,0xFFFF,0xFFF5,0x5028,0xFFCF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF7EF,0xFFFB,0xEAAB,0x7FFF,0xFFFF,0xFBEF,0xFFFF,0xFFFE,0xAA2F,0x7F2A,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xDB5F,0xB55B,0xFEAB,0xFFF7,0xFFDD,0xFFFF,0xFFFF,0xD017,0xFFF7,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFEF,0xDAAE,0xBBD5,0x5ADF,0xFFF7,0xFFFF,0xFFFF,0xF903,0xBFFB,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x7DBF,0xEDB5,0xEF56,0xEFBF,0xFFFF,0xFFFF,0xFFFF,0xE284,0xB7FF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFBDF,0xFFFB,0x56EB,0xFFFF,0xFFFF,0xFFFF,0xF400,0x0BFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFAF,0xFF7D,0x7FDD,0xAB55,0xFFFF,0xFFFF,0xFFFF,0x4901,0x00FF,0xFFFF,0xFFFF,0xFFFF,0xB57F,0xFFFF,0xFFFF,0xFFFF,0x7DF7,0xFEEE,0xAAAA,0xFFFF,0xFFFF,0xFFFE,0x8040,0x0BFF,0xAADF,0xFFFF,0xFF3B,0x6355,0x7FFF,0xFFFF,0xFFFF,0x7FDF,0xF7AB,0x5555,0x7FFF,0xB7FF,0xFFFC,0x4000,0x16DF,0x0000,0x2AB7,0xFF60,0xA003,0x5FFF,0xFFFF,0xFFFF,0x7FFF,0xF5D5,0x6AAD,0xD5FF,0xFFEF,0xFFFF,0x080A,0x9BFF,0x0000,0x0005,0x5400,0x0000,0x157F,0xFFFF,0xFFFF,0x3FFF,0xDB7F,0xBFF7,0xFFFF,0xFFBF,0xFFFF,0xFD55,0x5737,0x0000,0x0000,0x3000,0x0000,0x034A,0xBFFF,0xFFFF,0x3FFF,0xFFFF,0xFF5A,0xFFFB,0xFFFF,0xFFFF,0xFFFE,0xBC09,0x0000,0x0000,0x0000,0x0000,0x0001,0xAAD5,0xFFFF,0x7FFF,0xFFFF,0xFFFF,0xFFDF,0xFDFF,0xFFFF,0xFFFF,0x4252,0x0000,0x0000,0x0000,0x0000,0x0000,0x068D,0x7FFF,0x3FFF,0xFFFB,0x7FFF,0xFFFF,0xFFFF,0xFFFF,0xFFAA,0x02AB,0x0000,0x0000,0x0000,0x0000,0x0FFC,0x0000,0x97FF,0xFFFF,0xFFEC,0x2FFF,0xFFFF,0xFFFF,0xFFFF,0xFEF5,0x1ABF,0x0000,0x0000,0x0000,0x0000,0x47FD,0x0000,0x2BFF,0x7FBF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFE,0x25FF,0x0000,0x0000,0x0000,0x0001,0x61FC,0xA000,0x05BF,0xFEEA,0xAFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xA857,0x0000,0x0000,0x0007,0xC001,0xC4FF,0xA800,0x025F,0xD2AA,0x8815,0x7DFF,0xEAAB,0xFFFF,0xFFFF,0xFFFF,0xF417,0x4000,0x0000,0x000F,0xE40F,0x53FB,0xEC00,0x000A,0xC000,0x0000,0x0201,0x2AAD,0xFEFF,0xFFFF,0xFFFF,0xFA0B,0xB400,0x0000,0x001F,0xB93F,0x03FE,0x9600,0x000A,0xE000,0x0000,0x00AA,0xAAAA,0x2297,0xFFFF,0xFFFF,0xFD05,0xA800,0x0000,0x0179,0xD27F,0xEBFF,0x4C00,0x000A,0xC000,0x001E,0x0001,0x554A,0xAADD,0xFFFF,0xFFFF,0xFEAA,0xEE80,0x0092,0x417A,0x987F,0xF1BF,0xDB00,0x000A,0xC000,0x003F,0x0054,0x1255,0x526F,0x7FFF,0xFFFF,0xFFFD,0xFA12,0xAA40,0xDBD8,0x5AFD,0xF0BF,0xFC00,0x000A,0xC000,0x00DD,0x8109,0x4AAA,0xAAAB,0xDBFF,0xFFFF,0xFFFE,0xD555,0x2515,0x6190,0x59E1,0xFC3F,0x3590,0x8082,0xC000,0x038F,0x8050,0x2494,0xAAAD,0x7FFF,0xFFFF,0xFFFF,0xFD49,0x54A1,0xD824,0xDBFB,0xFC3E,0x65A4,0x01F6,0xC000,0x0F55,0x0001,0x0256,0xAAB6,0xD5FF,0xFFFF,0xFFFF,0xEA55,0x2A85,0x9E59,0xB3BC,0xFC0A,0xC589,0x4B3E,0xC1F7,0xDEC3,0x0000,0x1152,0xAADB,0x5EBF,0xFFFF,0xFFFF,0xFD4A,0xA527,0x8DB5,0x273C,0x3111,0x85C0,0xF756,0xC7BF,0x0C83,0x0000,0x015A,0xAB6D,0xABFF,0xFFFF,0xFFFF,0xF6A9,0x295F,0xCF68,0xEEBF,0x4C41,0x85AB,0x7B0C,0xCFDE,0xC127,0x8000,0x0025,0x5556,0xFFFF,0xFFFF,0xFFFF,0xFD55,0x5527,0x806A,0x6EFF,0x8013,0x8D8C,0x320C,0x5ECC,0xF2CD,0x8000,0x0112,0x4AAA,0xAEFF,0xFFFF,0xFFFF,0xF6AA,0x8891,0xC0BC,0x1CBF,0x5D16,0x0D1B,0x049E,0x3DDC,0x6DA8,0x0000,0x0041,0x2AAB,0x77FF,0xFFFF,0xFFFF,0xFD55,0x2000,0xFCF0,0xDC20,0x3D9C,0x3B73,0xCB36,0x7BF6,0x7B47,0x0000,0x7855,0x5555,0xAFFF,0xFFFF,0xFFFF,0xFD54,0x9200,0xF7E8,0xB818,0x9DF8,0x3BB1,0xB6A4,0xEFF4,0x0356,0x8001,0xFF02,0x92AA,0xDF7F,0xFFFF,0xFFFF,0xEAAA,0x4049,0x8F99,0xB81B,0xB9F8,0x7E39,0xED1A,0xE3F2,0x0475,0x2003,0x4A53,0x5556,0xF7FF,0xFFFF,0xFFFF,0xB400,0x0003,0xEFB9,0x7815,0xBBE8,0xF630,0x0D5A,0xC7FB,0xE72E,0xAAA6,0x92DD,0x5557,0xBDFF,0xFFFF,0xFFFF,0x4950,0x000F,0x0739,0x707B,0x3B50,0xF878,0x1BFB,0xC1A3,0xF1A8,0xAA0F,0xB2E4,0x2AAA,0xEFFF,0xFFFF,0xFFFF,0x9000,0x0003,0x077D,0x706B,0x3EA2,0x6E9F,0xFB2B,0xC056,0x72DB,0x555C,0xE67F,0xDAAF,0xBFFF,0xFFFF,0xFFFF,0x0000,0x0007,0x80FD,0x7076,0x1FD5,0x4E48,0x3B24,0xC11A,0x7067,0xAA9B,0xFF7F,0xED56,0xFFFF,0xFFFF,0xFFFF,0x0000,0x0001,0x82FD,0x70F6,0x0FDB,0xB9F0,0x73AA,0xE154,0xE07C,0x051B,0x3FFF,0xF6BB,0xDFFF,0xFFFF,0xFFFF,0x0000,0x0003,0x83F9,0x70EC,0x03FD,0x42B0,0xB3A5,0xE06A,0x6795,0x8037,0x6A07,0xFEAF,0x77FF,0xFFFF,0xFFFF,0x0000,0x3020,0xC0F9,0x70EE,0x00FF,0x43D0,0xF3AA,0xC006,0xE1EC,0x106F,0xD610,0x5D55,0xDFFF,0xFFFF,0xFFFF,0x0000,0x73D9,0xE0D9,0x71E3,0x807C,0x40C0,0x62BA,0xCC5A,0xEAAB,0xC0BF,0xD601,0xFD55,0x6DFF,0xFFFF,0xFFFF,0x0000,0xE7BC,0xE1C9,0x7181,0xE03A,0x2061,0xE2DB,0xC4BB,0xD863,0x018F,0xC609,0x7EAA,0xBF7F,0xFFFF,0xFFFF,0x0001,0xC44E,0x6089,0x7183,0x381A,0x0061,0xE23D,0xC061,0x9063,0xE31F,0xE707,0xFCAB,0x55FF,0xFFFF,0xFFFF,0x0003,0xFC22,0xF0C5,0x71C3,0xFC3D,0x60C2,0xC3DF,0xC05A,0x20E4,0xA686,0x8687,0xFDFD,0xEF7F,0xFFFF,0xFFFF,0x0007,0xAC2D,0x3045,0x71C1,0x860E,0xA883,0x83CF,0xC19E,0x59B0,0x9D81,0x5644,0xB8FD,0x5DDF,0xFFFF,0xFFFF,0x0007,0x4E1D,0x7045,0x71DD,0xD61F,0xD841,0xA1AF,0xC18D,0xB511,0x2AC4,0x7E23,0xB69B,0xAFFF,0xFFFF,0xFFFF,0x000F,0x481E,0xB865,0x715D,0xD40F,0x3F07,0xB11F,0xC1CF,0x6812,0x3625,0x7751,0xFD53,0xD56F,0xFFFF,0xFFFF,0x000F,0xF39E,0x9865,0x7164,0xEC0F,0x6367,0x96C7,0xC180,0x6A1C,0x4511,0xF6EE,0xAEEE,0x7EBF,0xFFFF,0xFFFF,0x000E,0xEFCE,0x986D,0x711C,0x9807,0xFB0B,0x44F7,0xC1C0,0xF92E,0x0099,0xFBFB,0xDB50,0xAF6F,0xFFFF,0xFFFF,0x001E,0xDBCB,0x9817,0x71EA,0xB007,0xC9DF,0x4F47,0xC1FF,0xE9ED,0x1015,0xE6F3,0xEFD0,0xF57F,0xFFFF,0xFFFF,0x001E,0xD1EF,0x982F,0xE1E2,0xE007,0x9ACF,0x4777,0x81F7,0x6E18,0x3E29,0xFFF9,0xEF17,0x36AD,0xFFFF,0xFFFF,0x001E,0x95E7,0xB816,0xF0D7,0x47C7,0x7B27,0x6BFF,0x81F6,0xFE08,0x6B31,0xEFFB,0xEE8F,0xDABF,0xFFFF,0xFFFF,0x001E,0x9463,0xB80E,0xF88F,0xC667,0xE1E3,0x678B,0x81F2,0x3F08,0x56C0,0xEE7A,0xEE83,0xF555,0xFFFF,0xFFFF,0x001E,0x3F67,0x982E,0xEB62,0x9E5F,0x4EED,0x793F,0x81FC,0x0F08,0x1786,0xFEFF,0xEF5B,0x0ABF,0xFFFF,0xFFFF,0x001E,0x2CA3,0x981E,0xE27A,0x8C2F,0xFFAF,0x7AF3,0x83EC,0x0F08,0x2F06,0xDEFD,0x6BAB,0x8548,0xFFFF,0xFFFF,0x001E,0x1CA1,0x9C1E,0xE7A2,0x9DE7,0xA2E6,0x9A5B,0x81E8,0x0708,0x0E05,0xF73D,0x69C8,0x3557,0x57BA,0xDBDD,0x001E,0x4AE1,0x9C1F,0xE3BA,0xBDE3,0xBE46,0x3BD3,0x83E8,0x0708,0x4505,0xDF7F,0xB8E5,0x12AA,0xAAFD,0xBF7F,0x001E,0x0DD0,0xBC1F,0xF5FE,0x99E1,0xEED3,0x19BF,0x83E8,0x070C,0x7305,0xD3BA,0xB865,0x32AA,0xABF7,0xEBEB,0x000F,0x00D0,0x981F,0xF3C4,0xBBC1,0xFD0A,0xDC27,0x07E8,0x070C,0x7F07,0xC7B9,0x506F,0x6055,0x55FE,0xFFAD,0x0007,0x1DD0,0x981B,0x7C9F,0xB303,0xF00D,0xFC7B,0x03E8,0x070C,0x4E07,0xC1D9,0x7C6A,0x1A0A,0xAFDF,0xFBF6,0x000F,0x0ED1,0x9815,0x7D79,0xE782,0xFE09,0xBE72,0x07E8,0x070C,0x4E07,0xC2F0,0x8268,0xCC43,0x55AF,0xDFFB,0x000F,0x8F81,0xF81A,0x5D2C,0xC704,0x3F8E,0x1E63,0x00FB,0x070C,0x4E07,0xD0EC,0x70E8,0xE409,0x55EB,0xDFEF,0x0003,0x8521,0x2819,0xCDE8,0x2F0C,0x0FC6,0xC663,0x8A7A,0xCF0C,0x4E07,0xF1F0,0x3DE2,0xFE01,0x4AAF,0xFBDD,0x0007,0xC6B2,0x5018,0xCCDF,0xF008,0x03E7,0x8E4A,0xFB2D,0x4E0E,0x6E0F,0xA0F5,0x55E9,0x1204,0x1555,0xF5FA,0x0002,0xF3BE,0x7818,0xFE1F,0x6018,0x01E5,0x4F4A,0x39E7,0xCE0E,0x0E07,0xB37B,0x0C74,0xFA00,0x5555,0x7FEA,0x0000,0xBFF8,0xA81B,0xA632,0x0820,0x01F1,0x4F0F,0xB98A,0xEE0E,0x2C0F,0xA432,0x4CBD,0x1A0A,0xCAAB,0xAED7,0x0000,0x01BF,0xF01B,0x2F20,0xB030,0x07D7,0x4716,0x5FFF,0x7B87,0xAC0F,0xBB44,0x1D7D,0x4F55,0x1555,0x5FAE,0x0000,0x0037,0xF01B,0x3700,0x4060,0x1EB3,0x430E,0x59BF,0x619F,0xBC1F,0xB3CA,0x372E,0x0C14,0xAAAA,0xAAFD,0x0000,0x0005,0xF017,0x1700,0x4040,0x7E45,0x4321,0x706F,0xDA38,0xD80F,0xB1B6,0xA237,0xE895,0x2AAA,0xAB75,0x0000,0x0001,0x701C,0xF300,0x40C3,0xE6C6,0x0706,0xE00B,0x9E59,0x381F,0xB9ED,0x0267,0xE000,0xD555,0x55EF,0x0000,0x0000,0xF014,0xD780,0x010F,0x1D0B,0x0780,0x6C07,0x8DA8,0x3C03,0xF00D,0x43C0,0x0000,0x1575,0x77EB,0x0000,0x0000,0x3918,0xD3D0,0x011C,0xAF1E,0x038E,0xEC01,0xCF40,0x1E29,0xF81F,0x2484,0x0000,0x0AAA,0xAA5D,0x0000,0x0000,0x1F23,0x33E8,0x0239,0xCE68,0x0187,0x6803,0x8060,0x1FEF,0x3FFE,0x7300,0x0000,0x0000,0x0040,0x0000,0x0000,0x17CC,0xE1F6,0x043D,0x8650,0x03C7,0xD000,0xC0C0,0x0FE7,0x5017,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x05FF,0x80BC,0x083C,0x99C0,0x03C2,0x8800,0x7E00,0x07E7,0x4003,0xFC00,0x0000,0x0000,0x0000,0x0000,0x0000,0x00FE,0x002F,0xF01E,0x1E80,0x01E3,0x5000,0x7E00,0x00FF,0x0001,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0008,0x200F,0x4D00,0x0179,0xC000,0x0000,0x00F8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xFD00,0x00FF,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xB200,0x00DF,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xD400,0x00CF,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xD800,0x00C7,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0xF000,0x00EF,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00EF,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00E7,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00EF,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00E7,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00EF,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00CF,0xE000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00CF,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00CD,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00C7,0xE000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00CF,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00CF,0xE000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0087,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00CF,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0087,0xE000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00CF,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0087,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00DF,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x008F,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00CF,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x008F,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00DF,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x008F,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x004F,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x009F,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x015F,0xB000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x013B,0x9000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x015F,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x01BB,0x9800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x016F,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x03DB,0x8800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0373,0x5800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x037B,0x8C00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x06F7,0xDC00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x077F,0x8C00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0EFB,0xC600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0E77,0x8E00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0CFB,0xC700,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E77,0x8B00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1CFB,0xC500,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000

alchimie_dark:
.word 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3FFE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFE03,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xF000,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xC007,0x8000,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001C,0x600E,0x0000,0x0C00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0038,0x301C,0x0000,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00F1,0x3038,0x0000,0x0600,0x0000,0x0000,0x007E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3FE7,0xB070,0x0000,0x0300,0x0000,0x0000,0x00E3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFFEF,0xB0E0,0x0000,0x0B00,0x0078,0x0000,0x01C1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0xE7DF,0x31C0,0x0000,0x1B00,0x038C,0x0000,0x0389,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xE7BE,0x63C0,0x0000,0x3B00,0x0704,0x00E1,0xFF3D,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xF278,0xE780,0x0000,0x7B00,0x0E24,0x03FF,0xFF7D,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xB0F1,0xC700,0x0380,0x7B07,0xFCF6,0x073F,0x3EF9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFF1,0xCF00,0x1FE0,0x731F,0xFDF6,0x0F1F,0x3DF3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFC3,0xCF40,0x3EE1,0xF33C,0xFBE4,0x1E07,0x93C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0xFF07,0x9FC0,0xEE63,0xC63C,0xF7CC,0x3C01,0x878E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7807,0x9FE1,0xDE07,0xC67E,0x4F1C,0x7003,0xFF8C,0x0000,0xFC00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xE007,0x3FE1,0x1C07,0x8476,0x1E38,0xF003,0xF80C,0x0001,0xB60F,0x8000,0x0000,0x0000,0x0000,0x0000,0x0007,0x0007,0x3FE3,0x3807,0x0C7F,0xFE31,0xF803,0xF804,0x0003,0x6E3E,0xC000,0x0000,0x0000,0x0000,0x0000,0x0007,0xF807,0x3F86,0x3C0F,0xFC3F,0xFC21,0xFC02,0xFE06,0x0006,0x4FFB,0xE000,0x0000,0x0000,0x0000,0x0000,0x0007,0xF803,0x7F86,0x1F1F,0x9F7F,0xFC61,0xFE02,0xFD06,0x000E,0x1F80,0x3000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFC03,0x7F8C,0x0F8E,0x07B0,0x3C61,0xFE04,0x7F82,0x001C,0x3A00,0x1800,0x0000,0x0000,0x0000,0x0000,0x0003,0xFC03,0x7F0C,0x03EC,0x0390,0x3C61,0xFE0C,0x7F83,0x003C,0x7200,0x0C00,0x0000,0x0000,0x0000,0x0000,0x0001,0xFC07,0x7F18,0x00F8,0x3D10,0x7C60,0xFE1C,0xF863,0x0078,0x0798,0x0400,0x0000,0x0000,0x0000,0x0000,0x0FC1,0xFE07,0x7F18,0x0038,0x3C10,0x7C61,0xFE7A,0xF801,0x80F0,0x0BCF,0x8400,0x0000,0x0000,0x0000,0x0000,0x7C30,0xFE27,0x7E1E,0x0038,0x3F30,0xFC61,0xFFE3,0xF100,0x81C0,0x03E6,0x0400,0x0000,0x0000,0x0000,0x0000,0xF808,0xFE37,0x7E3F,0x803C,0x1FE0,0xFC31,0xFFCF,0xE79C,0xC3C0,0x03F0,0x0400,0x0000,0x0000,0x0000,0x0001,0xF384,0xFF77,0x7E3C,0xE03C,0x1FC0,0xFC91,0xFF3F,0xEF9C,0x47E0,0x03F8,0x0400,0x0000,0x0000,0x0000,0x0001,0xC3C6,0x7F3B,0x7E3C,0x081E,0x0F81,0xFC09,0xFF65,0xDF1B,0x6F70,0x03F8,0x0400,0x0000,0x0000,0x0000,0x0003,0xC3C2,0x7FBB,0x7E3E,0x0C1F,0x0781,0xFC09,0xFEE7,0xBE4F,0x3E78,0x03F8,0x0C7E,0x0000,0x0000,0x0000,0x0007,0x81E3,0x3FBB,0x7E3E,0x0C0F,0x2783,0xDE05,0xFEF2,0x78EE,0xDC38,0x03F8,0x19E7,0xD800,0x0000,0x0000,0x0007,0x87E1,0x3F9B,0x7E3E,0x0C07,0xC0C3,0xCE05,0xFEB0,0xF1E5,0xC9D8,0x02B8,0xCB81,0xAC00,0x0000,0x0000,0x0007,0x0FE1,0xBF9B,0x7E18,0x1807,0x80C3,0xE023,0xFEFF,0xF1C3,0xA0E8,0x031F,0x0B00,0xE400,0x0000,0x0000,0x000F,0x1FF1,0xBF93,0x7E40,0x3007,0x04F7,0xE003,0xFEFF,0xE001,0xF360,0x0600,0x0E0F,0x4400,0x0000,0x0000,0x000F,0x31F0,0xBFC9,0x7E00,0x6007,0x3037,0xF003,0xFE7F,0xF402,0xE3E0,0x0F00,0x1E0F,0x0400,0x0000,0x0000,0x000F,0x31F0,0xBFD1,0xFE00,0x4007,0x603F,0xF803,0xFE0E,0xF1E7,0xC1C4,0x0E00,0x1E0F,0xC800,0x0000,0x0000,0x000F,0x63F0,0x9FC9,0xEF00,0xC007,0x00DF,0xF003,0xFE0C,0x3FF7,0x80CC,0x1E00,0x1F07,0xF000,0x0000,0x0000,0x000F,0x61F0,0x9FD1,0xE700,0x8FC7,0x1E1F,0xF803,0xFE0C,0x0FF7,0x803C,0x1F00,0x1F07,0xC000,0x0000,0x0000,0x000F,0xE0F0,0x9FC1,0xF011,0x8FB7,0xB01F,0xFE03,0xFE08,0x07F7,0xC078,0x1F00,0x1F82,0x0000,0x0000,0x0000,0x000F,0xF270,0x9FE1,0xF001,0x9FDF,0x805E,0xFC07,0xFC18,0x07F7,0xC0F8,0x3F00,0x1FC1,0x0000,0x0000,0x0000,0x000F,0xFE70,0x9FE1,0xF801,0x9E1F,0xDD1F,0x7D87,0xFC18,0x07F7,0xE1F8,0x1F80,0x1BF0,0xE000,0x0000,0x0000,0x000F,0xBC30,0x9FE0,0xFC01,0x9E1F,0xC01F,0xDC0F,0xFC18,0x07F7,0xF3F8,0x3780,0x09F8,0x7000,0x0000,0x0000,0x000F,0xD020,0x9FE0,0xF801,0xBE1F,0xC02E,0xFE43,0xFC18,0x07F3,0xF7F8,0x37C4,0x08F8,0xE000,0x0000,0x0000,0x000F,0xE020,0xBFE0,0xFC01,0xBC3F,0xE0F7,0x3FC3,0xF818,0x07F3,0xFFF8,0x33C6,0x0CF0,0xC000,0x0000,0x0000,0x000F,0xE020,0xBFE0,0xFF01,0xFC7E,0xFFF3,0xFF87,0xF818,0x07F3,0xDFF8,0x33E6,0x04F1,0xF000,0x0000,0x0000,0x0007,0xF020,0xBFE0,0xDE03,0xF87E,0x3FF3,0x1F8F,0xF818,0x07F3,0xCFF8,0x31EF,0x7EF3,0x1800,0x0000,0x0000,0x0007,0xF060,0xBFE0,0xDEC3,0xF0FC,0x0FF1,0x8F9F,0xF808,0x07F3,0xCFF8,0x21F3,0x8FF3,0x0C00,0x0000,0x0000,0x0007,0xF8C0,0xDFE0,0x5E07,0xC0F8,0x03F9,0x8F9F,0xF00D,0x87F3,0xCFF8,0x20FF,0x03F1,0x0400,0x0000,0x0000,0x0003,0xF9C0,0xAFE0,0x5F20,0x01F8,0x01F8,0xC7B1,0xC00A,0xC7F1,0xCFF0,0x607A,0x22F0,0xE600,0x0000,0x0000,0x0001,0xFFC0,0xE7E0,0x4FE0,0x03F0,0x00F8,0xC7B0,0xE00E,0x4FF1,0xEFF0,0x67FC,0xF2F8,0x0600,0x0000,0x0000,0x0000,0x7FFF,0x47E0,0x6FCC,0x07F0,0x00F8,0xC7F0,0x70F4,0x5FF1,0xEFF0,0x7FFD,0xB278,0x0600,0x0000,0x0000,0x0000,0x007F,0x07E0,0x67DF,0x0FE0,0x03B8,0xC7E9,0x3BF0,0x7FF0,0x6FF0,0x7CFB,0xE23E,0x0400,0x0000,0x0000,0x0000,0x000F,0xCFE0,0x67FF,0xBFC0,0x0F18,0xC7F3,0x3C7C,0xFFE0,0x6FE0,0x7CF7,0xC83F,0xF800,0x0000,0x0000,0x0000,0x0003,0xFFE0,0x77FF,0xBFC0,0x1C30,0xC7DE,0x181F,0xE5C7,0xDFE0,0x7E4F,0x1C2F,0xF000,0x0000,0x0000,0x0000,0x0000,0xFFE0,0x17FF,0xBF80,0xF820,0xC3E8,0x1807,0xE7BE,0x1FE0,0x761E,0x3C20,0x0000,0x0000,0x0000,0x0000,0x0000,0x7FE0,0x33FF,0xFF87,0xE243,0x83F0,0x1803,0xF270,0x1FE0,0x3FFE,0x3840,0x0000,0x0000,0x0000,0x0000,0x0000,0x7EE0,0x33EF,0xFF0F,0x0784,0x03F0,0x1803,0xB0E0,0x1FC0,0x3FFC,0x0180,0x0000,0x0000,0x0000,0x0000,0x0000,0x3FC0,0xE1F7,0xFE18,0x0718,0x03F8,0x1801,0xFFC0,0x0F00,0x3FFF,0x8F00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0FE3,0xC0F9,0xFC38,0x0030,0x01F8,0x3801,0xFF80,0x0780,0xE00F,0xFC00,0x0000,0x0000,0x0000,0x0000,0x0000,0x03FF,0x007F,0xF81E,0x0060,0x01FC,0x7000,0xFF00,0x03C3,0x8007,0xF800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xF01F,0x00C0,0x00FC,0xE000,0x0000,0x01EC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xC00F,0x8180,0x00FF,0x8000,0x0000,0x0070,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0x8300,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xC600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xEC00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0xE800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000

	
#=======================================================================#
|                                                                       #
|   Original x86 Assembler Program By Vulture.			#
|   68k conversion & modifications by Matt'Us Alem. 		#
|   Thanx Dejfam for help & debugging 			#
|   Figure morphing by Matt'US Alem.                                    #
|  						#
|   3D-system example. Use the following formulas to rotate a point:    #
|                                                                       #
|        Rotate around x-axis                                           #
|        YT = Y * COS(xang) - Z * SIN(xang) / 256                       #
|        ZT = Y * SIN(xang) + Z * COS(xang) / 256                       #
|        Y = YT                                                         #
|        Z = ZT                                                         #
|                                                                       #
|        Rotate around y-axis                                          	#
|        XT = X * COS(yang) - Z * SIN(yang) / 256                       #
|        ZT = X * SIN(yang) + Z * COS(yang) / 256                       #
|        X = XT                                                         #
|        Z = ZT                                                         #
|                                                                       #
|        Rotate around z-axis                                           #
|        XT = X * COS(zang) - Y * SIN(zang) / 256                       #
|        YT = X * SIN(zang) + Y * COS(zang) / 256                       #
|        X = XT                                                         #
|        Y = YT                                                         #
|                                                                       #
|   Divide by 256 coz we have multiplyd our sin values with 256 too.    #
|   This example isn't too fast right now but it'll work just fine.	#
|                                                                       #
|       Current Date: 6-9-95         Vulture			        #
|       Conversion Date : 20-11-01   Matt'US Alem		        #
|       Last modified : 25-09-04     Shazz for TI !                     #
|                                                                       #
#=======================================================================#

#
| Main routine:
| - Erase previous plots (t-1 & t-2 due to 2 buffers used)
| - Calculate for each points new coords and display each
| - Calculate angle for next rotation 
#		
FX_3DDots:	| Calculate first rotation angles

		jbsr 	sb3D_UpdateAngles 	| Calculate new angles
    		jbsr    sb3D_SetRotation  	| Find Sine & CoSine of those angles		

		moveq	#0,%d7			| Starting with point 0
		move.w	MaxPoints,%d6
		
		move.w	%d6,%d5
		lea 	EraseTbl,%a0
		
.LoopErase:	move.w	(%a0)+,%d0
		move.w	(%a0)+,%d1
		
		movem.l	%d5-%d6/%a0,-(%sp)

		jbsr 	delete_pixel
		|jbsr 	pixel_table_eraser  | bugged !!!
		
		
		movem.l	(%sp)+,%d5-%d6/%a0
		
		dbra	%d5,.LoopErase
		
				
		
.Loop:		lea	Atari,%a0
		jbsr	sb3D_RotatePoint  	| Rotates the point uSing above formulas
    		
    		movem.l %d6-%d7,-(%sp)
    		
		jbsr    sb3D_ShowPoint    	| Shows the point
		jbsr 	pixel_table_plotter
		
		movem.l (%sp)+,%d6-%d7
		
    		addq.w  #1,%d7          	| Next 3d-point
    		dbra	%d6,.Loop
   
   		|lea 	EraseTbl,%a0
   		|jbsr 	pixel_table_plotter
   		
   		jbsr vsync
   
		rts
		
#
| Main routine:
| - Erase previous plots (t-1 & t-2 due to 2 buffers used)
| - Calculate for each points new coords and display each
| - Calculate angle for next rotation 
#		
FX_3DWireframe:	| Calculate first rotation angles

		jbsr 	sb3D_UpdateAngles 	| Calculate new angles
    		jbsr    sb3D_SetRotation  	| Find Sine & CoSine of those angles		

		moveq	#0,%d7			| Starting with point 0
		move.w	MaxPoints2,%d6
		
		lea    EraseTbl,%a1				
		
.Loop21:	lea	Face1,%a0
		
		movem.l %d6-%d7/%a1,-(%sp)
		
		jbsr	sb3D_RotatePoint  	| Rotates the point uSing above formulas
		jbsr    sb3D_GetPoint    	| Shows the point
	
		movem.l (%sp)+,%d6-%d7/%a1
	
		move.w	%d1,(%a1)+
		move.w	%d2,(%a1)+
		
    		addq.w  #1,%d7          	| Next 3d-point
    		dbra	%d6,.Loop21
    		
    		lea    EraseTbl,%a1
    		move.w	MaxPoints2,%d6
    		subq.w	#1,%d6
    		
		jbsr	.LoopRot
   		
		moveq	#0,%d7			| Starting with point 0
		move.w	MaxPoints2,%d6
		
		lea    EraseTbl,%a1				
		
.Loop22:	lea	Face2,%a0
		
		movem.l %d6-%d7/%a1,-(%sp)
		
		jbsr	sb3D_RotatePoint  	| Rotates the point uSing above formulas
		jbsr    sb3D_GetPoint    	| Shows the point
	
		movem.l (%sp)+,%d6-%d7/%a1
	
		move.w	%d1,(%a1)+
		move.w	%d2,(%a1)+
		
    		addq.w  #1,%d7          	| Next 3d-point
    		dbra	%d6,.Loop22
    		
    		lea    EraseTbl,%a1
    		move.w	MaxPoints2,%d6
    		subq.w	#1,%d6
    		
		jbsr	.LoopRot
  		
   		
		moveq	#0,%d7			| Starting with point 0
		move.w	MaxPoints2,%d6
		
		lea    EraseTbl,%a1				
		
.Loop23:	lea	Face3,%a0
		
		movem.l %d6-%d7/%a1,-(%sp)
		
		jbsr	sb3D_RotatePoint  	| Rotates the point uSing above formulas
		jbsr    sb3D_GetPoint    	| Shows the point
	
		movem.l (%sp)+,%d6-%d7/%a1
	
		move.w	%d1,(%a1)+
		move.w	%d2,(%a1)+
		
    		addq.w  #1,%d7          	| Next 3d-point
    		dbra	%d6,.Loop23
    		
    		lea    EraseTbl,%a1
    		move.w	MaxPoints2,%d6
    		subq.w	#1,%d6
    		
		jbsr	.LoopRot		
   		
		moveq	#0,%d7			| Starting with point 0
		move.w	MaxPoints2,%d6
		
		lea    EraseTbl,%a1				
		
.Loop24:	lea	Face4,%a0
		
Rot_sub:	movem.l %d6-%d7/%a1,-(%sp)
		
		jbsr	sb3D_RotatePoint  	| Rotates the point uSing above formulas
		jbsr    sb3D_GetPoint    	| Shows the point
	
		movem.l (%sp)+,%d6-%d7/%a1
	
		move.w	%d1,(%a1)+
		move.w	%d2,(%a1)+
		
    		addq.w  #1,%d7          	| Next 3d-point
    		dbra	%d6,.Loop24
    		
    		lea    EraseTbl,%a1
    		move.w	MaxPoints2,%d6
    		subq.w	#1,%d6
    		
    		jbsr	.LoopRot
    		
    		jbsr vsync   		   		   		
   		jbsr clear_screens
    		
    		rts
    		
.LoopRot:	move.w	(%a1)+,%d1	 		   		
		move.w	(%a1)+,%d2
		move.w	(%a1),%d3
		move.w	2(%a1),%d4
		
		movem.l %d6/%a1,-(%sp)
		
    		jbsr 	draw_line
    		
    		movem.l (%sp)+,%d6/%a1
    		
    		dbra	%d6,.LoopRot
   		
		rts
		

init_3Drot:	| Called only one time before main loop 
		| initialize axxis speed rotations

   		move.w  	#2,DeltaX          | Initial speed of rotation
   		move.w  	#5,DeltaY          | Change this and watch what
    		move.w  	#3,DeltaZ          | happens. It's fun!

		| perspective distances

    		move.w   	#256,Xoff
    		move.w   	#256,Yoff         | Used for calculating vga-pos
   		move.w   	#480,Zoff         | 300: Distance from viewer

		rts

| Calculates new x,y,z angles
| to rotate around
sb3D_UpdateAngles:
		move.w     XAngle,%d0       	| Load current angle
		add.w      DeltaX,%d0        	| Add velocity
		andi.w     #0b11111111,%d0    	| Range from 0..255
		move.w     %d0,XAngle        	| Update X
		    
		move.w     YAngle,%d0
		add.w      DeltaY,%d0        	| Add velocity
		andi.w     #0b11111111,%d0    	| Range from 0..255
		move.w     %d0,YAngle        	| Update Y
		
		move.w     ZAngle,%d0
		add.w      DeltaZ,%d0        	| Add velocity
		andi.w     #0b11111111,%d0    	| Range from 0..255
		move.w     %d0,ZAngle        	| Update Z
	
		rts

| Needed : %d0.w = angle (0..255)
| Returns: %d1.w = Sin   %d2.w = Cos
| used : %d1,%d2,%a0
#
sb3D_GetSinCos:	
		lea	sintbl,%a0		| load SinCos table
		move.w	%d0,%d2			| Save angle (use as pointer)
		move.b  (%a0,%d2),%d1		| get Sine
		add.w	#64,%d2			| add 64 (-> pi/4)
		and.w	#0b11111111,%d2		| Range from 0..255
		move.b	(%a0,%d2),%d2		| get Cosine
		
		rts

| Set sine & cosine of x,y,z
| used %d0,%d1,%d2
sb3D_SetRotation:	
		move.w	XAngle,%d0		| Grab angle
		jbsr	sb3D_GetSinCos		| Get the sine&cosine : %d1 & %d2
		move.w	%d1,XSin		| Save sin
		move.w	%d2,XCos		| Save cos
		
		move.w	YAngle,%d0		| Grab angle
		jbsr	sb3D_GetSinCos		| Get the sine&cosine : %d1 & %d2
		move.w	%d1,YSin		| Save sin
		move.w	%d2,YCos		| Save Cos
		
		move.w	ZAngle,%d0		| Grab angle
		jbsr	sb3D_GetSinCos		| Get the Sine&CoSine : %d1 & %d2
		move.w	%d1,ZSin		| Save Sin
		move.w	%d2,ZCos		| Save Cos
		
		rts




| Rotates the point around x,y,z
| Gets original x,y,z values
| This can be done elsewhere
| in : %d7.w : offset
|      %a5 : 6x precalc table (3 coords * word size)
| used %a0 - %d0,%d1,%d2

sb3D_RotatePoint:	
		| save trashed registers
		movem.l	%d6-%d7/%a5,-(%SP)
		
		| can use precalc 6x table to replace mulu #3*2,%d1 
		move.w	%d7,%d1
		mulu 	#3*2,%d1

		move.w	(%a0,%d1.w),%d0		| get X and move 1 byte 
		adda.l	#2,%a0
		move.w	%d0,X			| save in current X
		
		move.w	(%a0,%d1.w),%d0		| get Y and move 1 byte 
		move.w	%d0,Y			| save in current Y
		adda.l	#2,%a0		

		move.w	(%a0,%d1.w),%d0		| get Z
		move.w	%d0,Z			| save in current Z
		
| Rotate around x-axis
| YT = Y * Cos(xang) - Z * Sin(xang) / 256
| ZT = Y * Sin(xang) + Z * Cos(xang) / 256
| Y = YT
| Z = ZT

		move.w	Y,%d0
		move.w	XCos,%d1
		muls.w	%d1,%d0		| %d0 = Y * Cos(xang)

		move.w	Z,%d1
		move.w	XSin,%d2
		muls.w	%d2,%d1		| %d1 = Z * Sin(xang)
		sub.l	%d1,%d0		| %d0 = Y * Cos(xang) - Z * Sin(xang)
		asr.l	#8,%d0		| %d0 = Y * Cos(xang) - Z * Sin(xang) / 256
		
		move.w	%d0,Yt		
		
		move.w	Y,%d0
		move.w	XSin,%d1
		muls.w	%d1,%d0		| %d0 = Y * Sin(xang)
		move.w	Z,%d1

		move.w	XCos,%d2
		muls.w	%d2,%d1		| %d1 = Z * Cos(xang)
		add.l	%d0,%d1		| %d1 = Y * Sin(xang) + Z * Cos(xang)
		asr.l	#8,%d1		| %d1 = Y * Sin(xang) + Z * Cos(xang) / 256
		move.w	%d1,Zt
		
		move.w	Yt,%d0		| Switch values Y=Yt,...
		move.w	%d0,Y
		move.w	Zt,%d0
		move.w	%d0,Z

| Rotate around y-axis
| XT = X * Cos(yang) - Z * Sin(yang) / 256
| ZT = X * Sin(yang) + Z * Cos(yang) / 256
| X = XT
| Z = ZT

		move.w	X,%d0
		move.w	YCos,%d1
		muls.w	%d1,%d0		| %d0 = X * Cos(xang)
		
		move.w	Z,%d1
		move.w	YSin,%d2
		muls.w	%d2,%d1		| %d1 = Z * Sin(xang)
		sub.l	%d1,%d0		| %d0 = X * Cos(xang) - Z * Sin(xang)
		asr.l	#8,%d0		| %d0 = X * Cos(xang) - Z * Sin(xang) / 256
		
		move.w	%d0,Xt		
		move.w	X,%d0

		move.w	YSin,%d1
		muls.w	%d1,%d0		| %d0 = X * Sin(xang)
		move.w	Z,%d1
		move.w	YCos,%d2
		muls.w	%d2,%d1		| %d1 = Z * Cos(xang)
		add.l	%d0,%d1		| %d1 = X * Sin(xang) + Z * Cos(xang)
		asr.l	#8,%d1		| %d1 = X * Sin(xang) + Z * Cos(xang) / 256
		move.w	%d1,Zt
		
		move.w	Xt,%d0		| Switch values X=Xt,...
		move.w	%d0,X
		move.w	Zt,%d0
		move.w	%d0,Z

| Rotate around z-axis
| XT = X * Cos(zang) - Y * Sin(zang) / 256
| YT = X * Sin(zang) + Y * Cos(zang) / 256
| X = XT
| Y = YT
	
		move.w	X,%d0
		move.w	ZCos,%d1
		muls.w	%d1,%d0		| %d0 = X * Cos(xang)
		
		move.w	Y,%d1
		move.w	ZSin,%d2
		muls.w	%d2,%d1		| %d1 = Y * Sin(xang)
		sub.l	%d1,%d0		| %d0 = X * Cos(xang) - Y * Sin(xang)
		asr.l	#8,%d0		| %d0 = X * Cos(xang) - Y * Sin(xang) / 256
		
		move.w	%d0,Xt		
		
		move.w	X,%d0
		move.w	ZSin,%d1
		muls.w	%d1,%d0		| %d0 = X * Sin(xang)
		move.w	Y,%d1
		move.w	ZCos,%d2
		muls.w	%d2,%d1		| %d1 = Y * Cos(xang)
		add.l	%d0,%d1		| %d1 = X * Sin(xang) + Y * Cos(xang)
		asr.l	#8,%d1		| %d1 = X * Sin(xang) + Y * Cos(xang) / 256
		move.w	%d1,Yt
		
		move.w	Xt,%d0		| Switch values X=Xt,...
		move.w	%d0,X
		move.w	Yt,%d0
		move.w	%d0,Y	
	
		| restore trashed registers
		movem.l	(%SP)+,%d6-%d7/%a5
	
		rts

| Calculates screenposition and
| plots the point on the screen
| %d0,%d1,%d2		
sb3D_ShowPoint:	
		move.w	%d7,%d0
		mulu	#4,%d0
		lea 	EraseTbl,%a0
		adda.l	%d0,%a0
		
		moveq  #0,%d0

		move.w	Xoff,%d0		| Xoff*X / Z+Zoff = screen x
		move.w	X,%d1
		muls.w	%d0,%d1
		
		move.w	Z,%d0
		add.w	Zoff,%d0		| distance
		ext.l	%d0
		
		divs.w	%d0,%d1		
		move.l	Mx,%d0	
			
		ext.l	%d1
		add.l	%d0,%d1			| Center on screen
		ext.l	%d1
		
		move.w	Yoff,%d0		| Yoff*Y / Z+Zoff = screen y
		move.w	Y,%d2
		muls.w	%d0,%d2
		
		move.w	Z,%d0
		add.w	Zoff,%d0
		ext.l	%d0
		
		divs.w	%d0,%d2	
		move.l	My,%d0
		
		ext.l	%d2
		add.l	%d0,%d2			| Center on screen
		ext.l	%d2
		
		move.w  %d1,(%a0)+
		move.w  %d2,(%a0)
		
		rts
		
		/*move.l block,%a0
		lea +vball1_offset(%a0),%a0
		move.l block,%a1
		lea +vball2_offset(%a1),%a1
		move.l __L_plane,%a2
		move.l __D_plane,%a3		
		
		cmp.w #239-16,%d1
		bhi.s clip
		cmp.w #127-16,%d2
		bhi.s clip
	
		move.w %d1,%d0
		move.w %d2,%d1		
		jbsr AND_4_colors_draw_monochrome_16x16_sprite
		*/
		
clip:		rts

sb3D_GetPoint:	
		move.w	Xoff,%d0		| Xoff*X / Z+Zoff = screen x
		move.w	X,%d1
		muls.w	%d0,%d1
		
		move.w	Z,%d0
		add.w	Zoff,%d0		| distance
		ext.l	%d0
		
		divs.w	%d0,%d1		
		move.l	Mx,%d0	
			
		ext.l	%d1
		add.l	%d0,%d1			| Center on screen
		ext.l	%d1
		
		move.w	Yoff,%d0		| Yoff*Y / Z+Zoff = screen y
		move.w	Y,%d2
		muls.w	%d0,%d2
		
		move.w	Z,%d0
		add.w	Zoff,%d0
		ext.l	%d0
		
		divs.w	%d0,%d2	
		move.l	My,%d0
		
		ext.l	%d2
		add.l	%d0,%d2			| Center on screen
		ext.l	%d2
		
		rts

draw_pixel:
		move.l (0xC8),%a5
			
		move.w #1,-(%sp)
		move.w %d2,-(%sp)
		move.w %d1,-(%sp)
		
		move.l 4*0x1A8(%a5),%a0
		jbsr (%a0)
		lea 6(%a7),%a7	

		rts
		
delete_pixel:
		move.l (0xC8),%a5
			
		move.w #0,-(%sp)
		move.w %d1,-(%sp)
		move.w %d0,-(%sp)
		
		move.l 4*0x1A8(%a5),%a0
		jbsr (%a0)
		lea 6(%a7),%a7	

		rts	
		

draw_line:
		move.l (0xC8),%a5
			
		move.w #1,-(%sp)
		move.w %d4,-(%sp)
		move.w %d3,-(%sp)		
		move.w %d2,-(%sp)
		move.w %d1,-(%sp)
		
		move.l 4*0x1A7(%a5),%a0
		jbsr (%a0)
		lea 10(%a7),%a7	

		rts
			
       
XAngle:		.word 0      	| Angle to rotate around x
YAngle: 	.word 0
ZAngle:		.word 0
       		
Mx:    		.long 240/2        | Middle of the screen
My:    		.long 128/2
		       
MaxPoints:	.word 119 	| Number of 3d Points
MaxPoints2:	.word 4	| Number of 3d Points
       
X:     		.word 0             	| X variable for formula
Y:     		.word 0
Z:     		.word 0
Xt:    	 	.word 0             	| Temporary variable for x
Yt:    		.word 0
Zt:    		.word 0
   
DeltaX: 	.word 0             	| Amound Xangle is increased each time
DeltaY:		.word 0
DeltaZ:		.word 0
       
Xoff:   	.word 0
Yoff:   	.word 0
Zoff:   	.word 0             	| Distance from viewer
       
XSin:   	.word 0             	| Sine and CoSine of angle to rotate around
XCos:  		.word 0
YSin:  		.word 0
YCos:   	.word 0
ZSin:   	.word 0
ZCos:   	.word 0      			

CosPos: 	.word 0		| the position in the SinCos table
EraseTbl:
.rept	120
.long 0
.endr

|
| Atari Fuji logo, 120 points + 5 points unused
|
Atari:
		.word -25,70,-15	| top : line 0 (y=+70)
		.word -15,70,-15
		.word -25,70,5
		.word -15,70,5

		.word -10,70,-15
		.word 10,70,-15
		.word -10,70,5
		.word 10,70,5

		.word 15,70,-15
		.word 25,70,-15
		.word 15,70,5
		.word 25,70,5

		.word -25,55,-15	| line 1 (+55)
		.word -15,55,-15
		.word -25,55,5
		.word -15,55,5

		.word -10,55,-15
		.word 10,55,-15
		.word -10,55,5
		.word 10,55,5

		.word 15,55,-15
		.word 25,55,-15
		.word 15,55,5
		.word 25,55,5  	

		.word -25,40,-15	| line 2 (+40)
		.word -15,40,-15
		.word -25,40,5
		.word -15,40,5

		.word -10,40,-15
		.word 10,40,-15
		.word -10,40,5
		.word 10,40,5

		.word 15,40,-15
		.word 25,40,-15
		.word 15,40,5
		.word 25,40,5

		.word -25,25,-15	| line 3 (+25)
		.word -15,25,-15
		.word -25,25,5
		.word -15,25,5

		.word -10,25,-15
		.word 10,25,-15
		.word -10,25,5
		.word 10,25,5

		.word 15,25,-15
		.word 25,25,-15
		.word 15,25,5
		.word 25,25,5

		.word -27,10,-15	| line 4 (+10)
		.word -17,10,-15
		.word -27,10,5
		.word -17,10,5

		.word -10,10,-15
		.word 10,10,-15
		.word -10,10,5
		.word 10,10,5

		.word 17,10,-15
		.word 27,10,-15
		.word 17,10,5
		.word 27,10,5

		.word -32,-5,-15	| line 5 (-5)
		.word -20,-5,-15
		.word -32,-5,5
		.word -20,-5,5

		.word -10,-5,-15
		.word 10,-5,-15
		.word -10,-5,5
		.word 10,-5,5

		.word 20,-5,-15
		.word 32,-5,-15
		.word 20,-5,5
		.word 32,-5,5

		.word -40,-20,-15	| line 6 (-20)
		.word -25,-20,-15
		.word -40,-20,5
		.word -25,-20,5

		.word -10,-20,-15
		.word 10,-20,-15
		.word -10,-20,5
		.word 10,-20,5

		.word 25,-20,-15
		.word 40,-20,-15
		.word 25,-20,5
		.word 40,-20,5

		.word -55,-35,-15	| line 7 (-35)
		.word -32,-35,-15
		.word -55,-35,5
		.word -32,-35,5

		.word -10,-35,-15
		.word 10,-35,-15
		.word -10,-35,5
		.word 10,-35,5

		.word 32,-35,-15
		.word 55,-35,-15
		.word 32,-35,5
		.word 55,-35,5

		.word -78,-42,-15	| line 8 (-42)
		.word -38,-42,-15
		.word -78,-42,5
		.word -38,-42,5

		.word -10,-42,-15
		.word 10,-42,-15
		.word -10,-42,5
		.word 10,-42,5

		.word 38,-42,-15
		.word 78,-42,-15
		.word 38,-42,5
		.word 78,-42,5

		.word -78,-65,-15	| line 9 (-65,-60)
		.word -52,-60,-15
		.word -78,-65,5
		.word -52,-60,5

		.word -10,-65,-15
		.word 10,-65,-15
		.word -10,-65,5
		.word 10,-65,5

		.word 52,-60,-15
		.word 78,-65,-15
		.word 52,-60,5	
		.word 78,-65,5

Face1:
		.word	-40,40,40
		.word	-40,-40,40
		.word	-40,-40,-40
		.word	-40,40,-40
		.word	-40,40,40

Face2:		
		.word	-35,-35,35
		.word	35,-35,35
		.word	35,35,35
		.word	-35,35,35		
		.word	-35,-35,35

Face3:		
		.word	40,-40,-40
		.word	40,-40,40
		.word	40,40,40
		.word	40,40,-40
		.word	40,-40,-40
		
Face4:		
		.word	35,-35,-35
		.word	35,35,-35
		.word	-35,35,-35
		.word	-35,-35,-35
		.word	35,-35,-35
		
								